<?php
defined('BASEPATH') OR exit('No direct script access allowed');

require FCPATH . '/vendor/autoload.php';
use Dompdf\Dompdf;

// Include librari PhpSpreadsheet
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class Perolehan extends CI_Controller {
    function __construct()
	{
		parent::__construct();

		date_default_timezone_set('Asia/Jakarta');

		$this->load->model('m_data');
		$this->load->library('pdf');

		// cek session yang login, 
		// jika session status tidak sama dengan session telah_login, berarti pengguna belum login
		// maka halaman akan di alihkan kembali ke halaman login.
		if($this->session->userdata('status')!="telah_login"){
			redirect(base_url().'welcome?alert=belum_login');
		}
	}

    public function index()
	{
		//$data['perolehans'] = $this->m_data->get_data('perolehan')->result();

		$data['perolehans'] = $this->db->select('*')
							  ->from('perolehan as t1')
							  ->join('master_provinsi as t2', 't1.provinsi_id = t2.provinsi_id', 'LEFT')
							  ->join('master_kota as t3', 't1.kota_id = t3.kota_id', 'LEFT')
							  ->get()
							  ->result();

        //$data['progres'] = $this->m_data->get_data('perolehan_progres')->result();

		$data['progres'] = $this->db->select('*')
							->from('perolehan_progres as t1')
							->join('master_perolehan_status as t6', 't1.perolehan_status_id = t6.perolehan_status_id', 'LEFT')
							->join('master_perolehan_kegiatan as t7', 't1.perolehan_kegiatan_id = t7.perolehan_kegiatan_id', 'LEFT')
							->order_by("tgl_awal", "desc")
							->get()
							->result();

		$this->load->view('template/v_header');
		$this->load->view('perolehan/v_perolehan',$data);
		$this->load->view('template/v_footer');
	}
	public function perolehan_act(){
		$prov = $this->input->post('provinsi');
		//$prov = $this->db->query("SELECT * FROM master_provinsi WHERE provinsi_id = '$prov_id'")->row();
		//$provinsi = $prov->provinsi_nama;
		$kota = $this->input->post('kota');
		$kecamatan = $this->input->post('kecamatan');
		$kelurahan = $this->input->post('kelurahan');
		$luas = $this->input->post('luas');
		$ex_hak = $this->input->post('ex_hak');
		$dasar_perolehan = $this->input->post('dasar_perolehan');
		$pic = $this->input->post('pic');
		$status = $this->input->post('rkat');
		
		if ($status == "rkat") {
			$rkat = true;
		}else {
			$rkat = false;
		}

		$data = array(			
			'provinsi_id' => $prov,
			'kota_id' => $kota,
			'kecamatan_id' => $kecamatan,
			'kelurahan_id' => $kelurahan,
			'is_rkat' => $rkat,
			'perolehan_luas' => $luas,
			'bekas_pemegang_hak' => $ex_hak,
			'perolehan_dasar' => $dasar_perolehan,
			'perolehan_pic' => $pic
		);

		$this->m_data->insert_data($data,'perolehan');
		redirect(base_url().'Perolehan');
	}
	public function perolehan_update(){
		$id = $this->input->post('id');
		$prov = $this->input->post('provinsi');
		//$prov = $this->db->query("SELECT * FROM master_provinsi WHERE provinsi_id = '$prov_id'")->row();
		//$provinsi = $prov->provinsi_nama;
		$kota = $this->input->post('kota');
		$kecamatan = $this->input->post('kecamatan');
		$kelurahan = $this->input->post('kelurahan');
		$luas = $this->input->post('luas');
		$ex_hak = $this->input->post('ex_hak');
		$dasar_perolehan = $this->input->post('dasar_perolehan');
		$pic = $this->input->post('pic');
		$status = $this->input->post('rkat');
		
		if ($status == "rkat") {
			$rkat = true;
		}else {
			$rkat = false;
		}

		$where = array(
			'perolehan_id' => $id
		);

		$data = array(			
			'provinsi_id' => $prov,
			'kota_id' => $kota,
			'kecamatan_id' => $kecamatan,
			'kelurahan_id' => $kelurahan,
			'is_rkat' => $rkat,
			'perolehan_luas' => $luas,
			'bekas_pemegang_hak' => $ex_hak,
			'perolehan_dasar' => $dasar_perolehan,
			'perolehan_pic' => $pic
		);

		$this->m_data->update_data($where, $data,'perolehan');
		redirect(base_url().'Perolehan');
	}
	public function perolehan_hapus($id)
	{
		$where = array(
			'perolehan_id' => $id
		);

		$this->m_data->delete_data($where,'perolehan');		
		redirect(base_url().'Perolehan');
	}

	public function progres_perolehan($id)
	{
		$data['perolehan'] = $this->db->select('*')
							  ->from('perolehan as t1')
							  ->where('t1.perolehan_id', $id)
							  ->join('master_provinsi as t2', 't1.provinsi_id = t2.provinsi_id', 'LEFT')
							  ->join('master_kota as t3', 't1.kota_id = t3.kota_id', 'LEFT')
							  ->join('master_kecamatan as t4', 't1.kecamatan_id = t4.kecamatan_id', 'LEFT')
							  ->join('master_kelurahan as t5', 't1.kelurahan_id = t5.kelurahan_id', 'LEFT')
							  ->get()
							  ->row();
		
		$data['progres'] = $this->db->select('*')
							->from('perolehan_progres as t1')
						    ->where('t1.perolehan_id', $id)
							->join('master_perolehan_status as t6', 't1.perolehan_status_id = t6.perolehan_status_id', 'LEFT')
							->join('master_perolehan_kegiatan as t7', 't1.perolehan_kegiatan_id = t7.perolehan_kegiatan_id', 'LEFT')
							->order_by("tgl_akhir", "desc")
							->get()
							->result();

        //$data['progres'] = $this->db->query("SELECT * FROM perolehan_progres WHERE perolehan_id = '$id' ORDER BY progres_tanggal DESC")->result();
		
		$this->load->view('template/v_header');
		$this->load->view('perolehan/v_progres_perolehan', $data);
		$this->load->view('template/v_footer');
	}
	public function progres_act(){
		$perolehan = $this->input->post('perolehan_id');
		//$nama = $this->input->post('nama');
		//$tanggal = $this->input->post('tgl_progres');
		$status = $this->input->post('status');
		$kegiatan = $this->input->post('kegiatan');
		$keterangan = $this->input->post('ket_progres');
		$awal = $this->input->post('tgl_awal');
		$akhir = $this->input->post('tgl_akhir');

		if ($akhir) {
			$data = array(			
				'perolehan_id' => $perolehan,
				//'progres_tanggal' => $tanggal,
				//'progres_desc' => $nama,
				'perolehan_status_id' => $status,
				'perolehan_kegiatan_id' => $kegiatan,
				'tgl_awal' => $awal,
				'tgl_akhir' => $akhir,
				'progres_ket' => $keterangan
			);
		}else {
			$data = array(			
				'perolehan_id' => $perolehan,
				//'progres_tanggal' => $tanggal,
				//'progres_desc' => $nama,
				'perolehan_status_id' => $status,
				'perolehan_kegiatan_id' => $kegiatan,
				'tgl_awal' => $awal,
				//'tgl_akhir' => $akhir,
				'progres_ket' => $keterangan
			);
		}
		

		$this->m_data->insert_data($data,'perolehan_progres');
		//redirect(base_url().'Perolehan/progres_perolehan/'.$perolehan);
		redirect(base_url().'Perolehan');
	}
	public function progres_update(){
		$id = $this->input->post('id');
		$perolehan = $this->input->post('perolehan_id');
		//$nama = $this->input->post('nama');
		//$tanggal = $this->input->post('tgl_progres');
		$status = $this->input->post('status');
		$kegiatan = $this->input->post('kegiatan');
		$awal = $this->input->post('tgl_awal');
		$akhir = $this->input->post('tgl_akhir');
		$keterangan = $this->input->post('ket_progres');

		$where = array(
			'progres_id' => $id
		);

		$data = array(			
			//'progres_tanggal' => $tanggal,
			//'progres_desc' => $nama,
			'perolehan_status_id' => $status,
			'perolehan_kegiatan_id' => $kegiatan,
			'tgl_awal' => $awal,
			'tgl_akhir' => $akhir,
			'progres_ket' => $keterangan
		);

		$this->m_data->update_data($where, $data,'perolehan_progres');
		redirect(base_url().'Perolehan/progres_perolehan/'.$perolehan);
	}
	public function progres_hapus($id)
	{
		$where = array(
			'progres_id' => $id
		);

		$progres = $this->db->query("SELECT * FROM perolehan_progres WHERE progres_id = '$id'")->row();

		$this->m_data->delete_data($where,'perolehan_progres');		
		redirect(base_url().'Perolehan/progres_perolehan/'.$progres->perolehan_id);
	}
}