<?php
defined('BASEPATH') OR exit('No direct script access allowed');

require FCPATH . '/vendor/autoload.php';
use Dompdf\Dompdf;

// Include librari PhpSpreadsheet
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class Master extends CI_Controller {
    function __construct()
	{
		parent::__construct();

		date_default_timezone_set('Asia/Jakarta');

		$this->load->model('m_data');
		$this->load->library('pdf');

		// cek session yang login, 
		// jika session status tidak sama dengan session telah_login, berarti pengguna belum login
		// maka halaman akan di alihkan kembali ke halaman login.
		if($this->session->userdata('status')!="telah_login"){
			redirect(base_url().'welcome/alert=belum_login');
		}
	}

    public function index()
	{
		$data['provinsis'] = $this->db->query("SELECT * FROM master_provinsi ORDER BY provinsi_nama")->result();
		$this->load->view('template/v_header');
		$this->load->view('master/v_provinsi',$data);
		$this->load->view('template/v_footer');
	}

    public function provinsi()
	{
		$data['provinsis'] = $this->db->query("SELECT * FROM master_provinsi ORDER BY provinsi_nama")->result();
		$this->load->view('template/v_header');
		$this->load->view('master/v_provinsi',$data);
		$this->load->view('template/v_footer');
	}
	public function provinsi_act(){
		$nama = $this->input->post('nama');
		$data = array(			
			'provinsi_nama' => $nama
		);

		$this->m_data->insert_data($data,'provinsi');
		redirect(base_url().'master/provinsi');
	}
	public function provinsi_update()
	{
		$id = $this->input->post('id');
		$nama = $this->input->post('nama');
		$where = array(
			'provinsi_id' => $id
		);

		$data = array(
			'provinsi_nama' => $nama
		);

		$this->m_data->update_data($where, $data,'provinsi');
		redirect(base_url().'master/provinsi');
	}
	public function provinsi_hapus($id)
	{
		$where = array(
			'provinsi_id' => $id
		);

		$this->m_data->delete_data($where,'provinsi');		
		redirect(base_url().'master/provinsi');
	}

    public function kota()
	{
		//$data['kotas'] = $this->m_data->get_data('master_kota')->result();

		$data['kotas'] = $this->db->select('*')
							  ->from('master_kota as t1')
							  ->join('master_provinsi as t2', 't1.provinsi_id = t2.provinsi_id', 'LEFT')
							  ->order_by('kota_nama', 'asc')
							  ->get()
							  ->result();
		$data['provinsis'] = $this->m_data->get_data('master_provinsi')->result();
		$this->load->view('template/v_header');
		$this->load->view('master/v_kota',$data);
		$this->load->view('template/v_footer');
	}
	public function kota_act(){
		$nama = $this->input->post('nama');
		$provinsi = $this->input->post('provinsi');
		$data = array(			
			'kota_nama' => $nama,
			'provinsi_id' => $provinsi
		);

		$this->m_data->insert_data($data,'kota');
		redirect(base_url().'master/kota');
	}
	public function kota_update()
	{
		$id = $this->input->post('id');
		$nama = $this->input->post('nama');
		$provinsi = $this->input->post('provinsi');
		$where = array(
			'kota_id' => $id
		);

		$data = array(
			'kota_nama' => $nama,
			'provinsi_id' => $provinsi
		);

		$this->m_data->update_data($where, $data,'kota');
		redirect(base_url().'master/kota');
	}
	public function kota_hapus($id)
	{
		$where = array(
			'kota_id' => $id
		);

		$this->m_data->delete_data($where,'kota');		
		redirect(base_url().'master/kota');
	}

    public function dasar_perolehan()
	{
		$data['dasar_perolehans'] = $this->m_data->get_data('master_dasar_perolehan')->result();
		$this->load->view('template/v_header');
		$this->load->view('master/v_dasar_perolehan',$data);
		$this->load->view('template/v_footer');
	}
	public function dasar_perolehan_act(){
		$nama = $this->input->post('nama');
		$data = array(			
			'dasar_perolehan_desc' => $nama
		);

		$this->m_data->insert_data($data,'master_dasar_perolehan');
		redirect(base_url().'master/dasar_perolehan');
	}
	public function dasar_perolehan_update()
	{
		$id = $this->input->post('id');
		$nama = $this->input->post('nama');
		$where = array(
			'dasar_perolehan_id' => $id
		);

		$data = array(
			'dasar_perolehan_desc' => $nama
		);

		$this->m_data->update_data($where, $data,'master_dasar_perolehan');
		redirect(base_url().'master/dasar_perolehan');
	}
	public function dasar_perolehan_hapus($id)
	{
		$where = array(
			'dasar_perolehan_id' => $id
		);

		$this->m_data->delete_data($where,'master_dasar_perolehan');		
		redirect(base_url().'master/dasar_perolehan');
	}

	public function progres_status()
	{
		$data['progres_status'] = $this->m_data->get_data('master_progres_status')->result();
		$this->load->view('template/v_header');
		$this->load->view('master/v_progres_status',$data);
		$this->load->view('template/v_footer');
	}
	public function progres_status_act(){
		$nama = $this->input->post('nama');
		$data = array(			
			'progres_status_desc' => $nama
		);

		$this->m_data->insert_data($data,'master_progres_status');
		redirect(base_url().'master/progres_status');
	}
	public function progres_status_update()
	{
		$id = $this->input->post('id');
		$nama = $this->input->post('nama');
		$where = array(
			'progres_status_id' => $id
		);

		$data = array(
			'progres_status_desc' => $nama
		);

		$this->m_data->update_data($where, $data,'master_progres_status');
		redirect(base_url().'master/progres_status');
	}
	public function progres_status_hapus($id)
	{
		$where = array(
			'progres_status_id' => $id
		);

		$this->m_data->delete_data($where,'master_progres_status');		
		redirect(base_url().'master/progres_status');
	}

	public function status_perolehan()
	{
		$data['status_perolehans'] = $this->m_data->get_data('master_perolehan_status')->result();
		$this->load->view('template/v_header');
		$this->load->view('master/v_status_perolehan',$data);
		$this->load->view('template/v_footer');
	}
	public function status_perolehan_act(){
		$nama = $this->input->post('nama');
		$alert = $this->input->post('warna');
		$urutan = $this->input->post('urutan');
		$data = array(			
			'perolehan_status_nama' => $nama,
			'tahapan' => $urutan,
			'alert' => $alert
		);

		$this->m_data->insert_data($data,'master_perolehan_status');
		redirect(base_url().'master/status_perolehan');
	}
	public function status_perolehan_update()
	{
		$id = $this->input->post('id');
		$nama = $this->input->post('nama');
		$alert = $this->input->post('warna');
		$urutan = $this->input->post('urutan');

		$where = array(
			'perolehan_status_id' => $id
		);

		$data = array(
			'perolehan_status_nama' => $nama,
			'tahapan' => $urutan,
			'alert' => $alert
		);

		$this->m_data->update_data($where, $data,'master_perolehan_status');
		redirect(base_url().'master/status_perolehan');
	}
	public function status_perolehan_hapus($id)
	{
		$where = array(
			'perolehan_status_id' => $id
		);

		$this->m_data->delete_data($where,'master_perolehan_status');		
		redirect(base_url().'master/status_perolehan');
	}

	public function kegiatan_perolehan()
	{
		$data['kegiatan_perolehans'] = $this->db->select('*')
							  ->from('master_perolehan_kegiatan as t1')
							  ->join('master_perolehan_status as t2', 't1.perolehan_status_id = t2.perolehan_status_id', 'LEFT')
							  ->get()
							  ->result();

		$this->load->view('template/v_header');
		$this->load->view('master/v_kegiatan_perolehan',$data);
		$this->load->view('template/v_footer');
	}
	public function kegiatan_perolehan_act(){
		$nama = $this->input->post('nama');
		$status = $this->input->post('status_id');
		
		$data = array(			
			'perolehan_kegiatan_desc' => $nama,
			'perolehan_status_id' => $status
		);

		$this->m_data->insert_data($data,'master_perolehan_kegiatan');
		redirect(base_url().'master/kegiatan_perolehan');
	}
	public function kegiatan_perolehan_update()
	{
		$id = $this->input->post('id');
		$nama = $this->input->post('nama');
		$status = $this->input->post('status_id');

		$where = array(
			'perolehan_kegiatan_id' => $id
		);

		$data = array(
			'perolehan_kegiatan_desc' => $nama,
			'perolehan_status_id' => $status
		);

		$this->m_data->update_data($where, $data,'master_perolehan_kegiatan');
		redirect(base_url().'master/kegiatan_perolehan');
	}
	public function kegiatan_perolehan_hapus($id)
	{
		$where = array(
			'perolehan_kegiatan_id' => $id
		);

		$this->m_data->delete_data($where,'master_perolehan_kegiatan');		
		redirect(base_url().'master/kegiatan_perolehan');
	}

	function get_kota(){
		$id = $this->input->post('id',TRUE);
		$data = $this->db->query("SELECT * from master_kota WHERE provinsi_id='$id' ORDER BY kota_nama")->result();
		if (!empty($data)) { ?>

			<option>--Pilih Kota--</option>
			<?php   foreach ($data as $d) { ?>

					<option value="<?php echo $d->kota_id; ?>"><?php echo $d->kota_nama; ?></option>
			
			<?php	} ?>
		
		<?php }
	}

	function get_kecamatan(){
		$id = $this->input->post('id',TRUE);
		$data = $this->db->query("SELECT * from master_kecamatan WHERE kota_id='$id' ORDER BY kecamatan_nama")->result();
		if (!empty($data)) { ?>

			<option>--Pilih Kecamatan--</option>
			<?php   foreach ($data as $d) { ?>

					<option value="<?php echo $d->kecamatan_id; ?>"><?php echo $d->kecamatan_nama; ?></option>
			
			<?php	} ?>
		
		<?php }
	}

	function get_kelurahan(){
		$id = $this->input->post('id',TRUE);
		$data = $this->db->query("SELECT * from master_kelurahan WHERE kecamatan_id='$id' ORDER BY kelurahan_nama")->result();
		if (!empty($data)) { ?>

			<option>--Pilih Kelurahan/Desa--</option>
			<?php   foreach ($data as $d) { ?>

					<option value="<?php echo $d->kelurahan_id; ?>"><?php echo $d->kelurahan_nama; ?></option>
			
			<?php	} ?>
		
		<?php }
	}

	function reset_selection(){
		?>
			<option>No Selection</option>
		<?php
	}

	function get_kegiatan_perolehan(){
		$id = $this->input->post('id',TRUE);
		$data = $this->db->query("SELECT * from master_perolehan_kegiatan WHERE perolehan_status_id='$id'")->result();
		if (!empty($data)) { ?>

			<option>--Pilih Kegiatan--</option>
			<?php   foreach ($data as $d) { ?>

					<option value="<?php echo $d->perolehan_kegiatan_id; ?>"><?php echo $d->perolehan_kegiatan_desc; ?></option>
			
			<?php	} ?>
		
		<?php }
	}
}